/*****************************************************************************
*  LPC11U6x_E6x SCT demo program
*
*  Use SCT0 timer to generate four-channel PWM
*  SCT_IN0 is used as ABORT input
*****************************************************************************/
#include "nxp_lpc11u6x.h"

extern void SCT0_Init(void);

volatile uint32_t numPwmCycles;
volatile int      pwmAborted;
volatile int      pwmPhase;

void SCT0_1_IRQHandler(void)
{
  uint32_t status = LPC_SCT0->EVFLAG;

    if (status & (1 << 0))                                 // event 0 irq?
    {
        ++numPwmCycles;                                    // interrupt once per PWM cycle
    }
    if (status & (1 << 5))                                 // event 5 irq?
    {
        pwmAborted = 1;                                    // Abort interrupt
    }
    LPC_SCT0->EVFLAG = status;                             // clear interrupt flag
}

int main (void)
{
  uint32_t lastCycles;

    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)                // enable clock for IOCON
                               | (1u << 31);               // enable clock for SCT0/1

    LPC_IOCON->PIO1_25 = 0x00000083;                       // P1_25 is SCT0_IN0 used as ABORT
    LPC_IOCON->PIO1_19 = 0x00000082;                       // P1_19 is SCT0_OUT0 = green trace  = PWM1
    LPC_IOCON->PIO2_2  = 0x00000083;                       // P2_2  is SCT0_OUT1 = red trace    = PWM2
    LPC_IOCON->PIO2_7  = 0x00000082;                       // P2_7  is SCT0_OUT2 = yellow trace = PWM3
    LPC_IOCON->PIO1_13 = 0x00000082;                       // P1_13 is SCT0_OUT3 = blue trace   = PWM4

    SCT0_Init();                                           // Initialize SCT0

    while (1)                                              // loop forever
    {
       	if (numPwmCycles != lastCycles)
       	{
            lastCycles = numPwmCycles;
   		    if ((lastCycles % 5) == 0)                     // every few PWM cycles change the duty cycles
   		    {
                LPC_SCT0->CONFIG |= (1 << 7);              // NORELOAD_L (U)
                if (pwmPhase == 0)
                {
                	LPC_SCT0->MATCHREL[1].U = 200000;
                	LPC_SCT0->MATCHREL[3].U = 700000;
                }
                else
                {
                	LPC_SCT0->MATCHREL[1].U = 950000;
                	LPC_SCT0->MATCHREL[3].U = LPC_SCT0->MATCHREL[0].U;	// duty cycle 0 (test conflict resolution)
                }
                LPC_SCT0->CONFIG &= ~(1 << 7);             // NORELOAD_L (U)

                ++pwmPhase;
                if (pwmPhase > 1)
                {
                    pwmPhase = 0;
                }
            }
        }
        if (pwmAborted)          /* Demo: Poll ABORT input, and restart timer if abort condition has gone. */
        {
            while (!(LPC_SCT0->INPUT & (1 << 0))) ;

            LPC_SCT0->CTRL_U &= ~(1 << 2);                 /* HALT_L (U) */
            pwmAborted = 0;
        }
    }
}
